/***********************************************************************
UDF for specifying steady-state velocity profile boundary condition
************************************************************************/
#include "udf.h"
DEFINE_PROFILE(inlet_y_velocity, t, i)
{
real x[ND_ND];			/* zmienna przechowujaca wspolrzedne wezlow siatki, w 3D sa 3 skladowe indeksowane 0, 1 i 2 */
real x_cor;				/* zmienna przechowujaca wspolrzedna x srodka danej komorki */
real y_cor;				/* zmienna przechowujaca wspolrzedna y srodka danej komorki */
real l;					/* odleglosc srodka danej komorki od osi z */
real vmax = 1.746;		/* predkosc maksymalna w osi rury (wartosc stala) */
real vave = 1.746;		/* predkosc srednia w osi rury */
real n;					/* wykladnik modelu */
real Re = 10426;		/* liczba Reynoldsa */
real R = 0.006;			/* promien rury */
real v;					/* predkosc lokalna w srodku danejkomorki */
face_t f;				/* zmienna okreslajaca, o jaka powierzchnie chodzi - tu o "velocity_inlet" */

/* petla po komorkach (tu: t) danej powierzchni (tu: f) */
begin_f_loop(f,t)
{
F_CENTROID(x,f,t);									/* funkcja zwracajaca wspolrzedne srodka komorki t */
x_cor = x[0];										/* przypisanie zmiennej x pierwszej wspolrzednej wektora pozycji */
y_cor = x[1];										/* przypisanie zmiennej y drugiej wspolrzednej wektora pozycji */
l = sqrt(x_cor*x_cor + y_cor*y_cor);				/* obliczenie odleglosci srodka komorki od osi z */
/* n = 1.0 + pow(Re/50.0, 1/6); */					/* obliczenie wykladnika modelu : wzór (7) z artykulu - tu 3.41 (wariant A) */
/* n = 1.03*log(Re)-3.6; */ 						/* obliczenie wykladnika modelu : wzór (8) z artykulu - tu 5.88 (wariant (B)) */
n = 7; 												/* przyjecie wartosci typowej (wariant C) */
/* v = vmax*(1.0-pow(l/R, n)); */					/* obliczenie predkosci lokalnej : wzor (5) z artykulu */
v = (vave/2)*(1/n+1)*(1/n+2)*(1.0-pow(l/R, n));		/* obliczenie predkosci lokalnej : wzor (6) z artykulu */
F_PROFILE(f,t,i) = v;								/* przypisanie wartosci do srodka danej komorki */
}
end_f_loop(f,t)
}